 aR  w Q m^9      h	 oP      nSystem-wide
        NAME  MsDos_Patch


PUBLIC MsReplaceInterrupts, MsExitBackground
PUBLIC lastDataWord, lastCodeWord, lastConstant

EXTRN patched: BYTE
EXTRN msDosIntOffset:WORD, msDosIntSegment:WORD

EXTRN PLMInterrupt21:NEAR, PLMOuterrupt21:NEAR

EXTRN PLMInterrupt20:NEAR, PLMInterrupt22:NEAR, PLMInterrupt23:NEAR
EXTRN PLMInterrupt24:NEAR, PLMInterrupt25:NEAR, PLMInterrupt26:NEAR
EXTRN PLMInterrupt27:NEAR, PLMInterrupt28:NEAR, PLMInterrupt29:NEAR
EXTRN PLMInterrupt2A:NEAR, PLMInterrupt2B:NEAR, PLMInterrupt2C:NEAR
EXTRN PLMInterrupt2D:NEAR, PLMInterrupt2E:NEAR, PLMInterrupt2F:NEAR

oldExitCmd    EQU 00H
createPdbCmd  EQU 26H
loadAndGoCmd  EQU 4BH

FALSE         EQU 0
TRUE          EQU 1

CGROUP   GROUP CODE, LCODE
DGROUP   GROUP DATA, LDATA
IGROUP   GROUP CONST

CODE    SEGMENT  PUBLIC 'CODE'
ASSUME  CS:CGROUP, DS:DGROUP

$EJECT
;==================================================
;
;  MsReplaceInterrupts: PROCEDURE CLEAN;
;
;==================================================
      
MsReplaceInterrupts PROC NEAR

    PUSH DS

    CLI

    XOR  AX, AX
    MOV  ES, AX               ; Intr Vectors


    MOV  BX, 20H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt20Off, SI
    MOV  CS:oldInt20Seg, DS

    MOV  ES:[BX+0], OFFSET Int20
    MOV  ES:[BX+2], CS


    MOV  BX, 0C1H               ; CP/M Long Jump
    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldCpmJmpOff, SI
    MOV  CS:oldCpmJmpSeg, DS    ; Save old CP/M Jump

    MOV  ES:[BX+0], OFFSET Cpm
    MOV  ES:[BX+2], CS          ; Set new CP/M Jump

    MOV  BX, 21H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt21Off, SI
    MOV  CS:oldInt21Seg, DS

    MOV  ES:[BX+0], OFFSET Int21
    MOV  ES:[BX+2], CS

    MOV  CS:msDosIntOffset,  SI ; This is for the
    MOV  CS:msDosIntSegment, DS ; MsCalls module -
    MOV  CS:patched, TRUE       ; avoids ^C problem


    MOV  BX, 22H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt22Off, SI
    MOV  CS:oldInt22Seg, DS

    MOV  ES:[BX+0], OFFSET Int22
    MOV  ES:[BX+2], CS


    MOV  BX, 23H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt23Off, SI
    MOV  CS:oldInt23Seg, DS

    MOV  ES:[BX+0], OFFSET Int23
    MOV  ES:[BX+2], CS


    MOV  BX, 24H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt24Off, SI
    MOV  CS:oldInt24Seg, DS

    MOV  ES:[BX+0], OFFSET Int24
    MOV  ES:[BX+2], CS


    MOV  BX, 25H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt25Off, SI
    MOV  CS:oldInt25Seg, DS

    MOV  ES:[BX+0], OFFSET Int25
    MOV  ES:[BX+2], CS


    MOV  BX, 26H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt26Off, SI
    MOV  CS:oldInt26Seg, DS

    MOV  ES:[BX+0], OFFSET Int26
    MOV  ES:[BX+2], CS


    MOV  BX, 27H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt27Off, SI
    MOV  CS:oldInt27Seg, DS

    MOV  ES:[BX+0], OFFSET Int27
    MOV  ES:[BX+2], CS


    MOV  BX, 28H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt28Off, SI
    MOV  CS:oldInt28Seg, DS

    MOV  ES:[BX+0], OFFSET Int28
    MOV  ES:[BX+2], CS


    MOV  BX, 29H * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt29Off, SI
    MOV  CS:oldInt29Seg, DS

    MOV  ES:[BX+0], OFFSET Int29
    MOV  ES:[BX+2], CS


    MOV  BX, 2AH * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt2AOff, SI
    MOV  CS:oldInt2ASeg, DS

    MOV  ES:[BX+0], OFFSET Int2A
    MOV  ES:[BX+2], CS


    MOV  BX, 2BH * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt2BOff, SI
    MOV  CS:oldInt2BSeg, DS

    MOV  ES:[BX+0], OFFSET Int2B
    MOV  ES:[BX+2], CS


    MOV  BX, 2CH * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt2COff, SI
    MOV  CS:oldInt2CSeg, DS

    MOV  ES:[BX+0], OFFSET Int2C
    MOV  ES:[BX+2], CS


    MOV  BX, 2DH * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt2DOff, SI
    MOV  CS:oldInt2DSeg, DS

    MOV  ES:[BX+0], OFFSET Int2D
    MOV  ES:[BX+2], CS


    MOV  BX, 2EH * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt2EOff, SI
    MOV  CS:oldInt2ESeg, DS

    MOV  ES:[BX+0], OFFSET Int2E
    MOV  ES:[BX+2], CS


    MOV  BX, 2FH * 4

    LDS  SI, DWORD PTR ES:[BX]

    MOV  CS:oldInt2FOff, SI
    MOV  CS:oldInt2FSeg, DS

    MOV  ES:[BX+0], OFFSET Int2F
    MOV  ES:[BX+2], CS


    MOV  CS:intrStackSP, OFFSET stackTop
    MOV  CS:intrStackSS, SEG    stackTop

    STI

    POP  DS
    RET
MsReplaceInterrupts ENDP
$EJECT

;==================================================
;
;  MsExitBackground: PROCEDURE CLEAN;
;
;==================================================

MsExitBackground PROC NEAR

    MOV  CL, 4
    XOR  DX, DX

    MOV  AX, OFFSET DGROUP:lastDataWord + 15
    SHR  AX, CL
    ADD  DX, AX

    MOV  AX, OFFSET CGROUP:lastCodeWord + 15
    SHR  AX, CL
    ADD  DX, AX

    MOV  AX, OFFSET lastConstant + 15
    SHR  AX, CL
    ADD  DX, AX

    ADD  DX, 16    ; For program prefix ??
    MOV  AL,  0
    MOV  AH, 31H   ; Exit w/ Keep Process
    INT  21H

    RET            ; Should never return here

MsExitBackground ENDP
$EJECT

Cpm PROC FAR
    POP  AX                       ; Throw away first IP
    POP  CS:callersCS             ; Save Return CS
    POP  AX                       ; Save Final IP

    PUSHF                         ; Simulate Interrupt
    CLI                           ; Simulate Interrupt
    PUSH CS:callersCS             ; Simulate Interrupt
    PUSH AX                       ; Simulate Interrupt

    MOV  AH, CL                   ; Make look like CP/M call
    CMP  AH, 24H                  ; Valid CP/M call ?
    JBE  Int21EntryFromCpm        ; Yes
    IRET                          ; Nope
Cpm ENDP
$EJECT

Int21 PROC FAR

Int21EntryFromCpm:
    PUSHF

;    CMP  AH, loadAndGoCmd
;    JNE  Int21NotLoadAndGo

;    JMP  Int21ExitJump

;Int21NotLoadAndGo:
    CMP  CS:inside, TRUE
    JNE  Int21Inside

    JMP  Int21ExitJump

Int21Inside:
    MOV  CS:inside, TRUE

    OR   AH, AH                    ; AH = oldExitCmd (0) ?
    JNZ  Int21CheckLoadAndGo
    JMP  Int21ExitCall

Int21CheckLoadAndGo:
    CMP  AH, loadAndGoCmd
    JNE  Int21CheckCreatePdbCall
    JMP  Int21ExitCall

Int21CheckCreatePdbCall:
    CMP  AH, createPdbCmd
    JNE  Int21NormalCall
    JMP  Int21ExitCall

Int21NormalCall:
    POPF

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    CALL AsmInterrupt21

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF
    CALL DWORD PTR CS:oldInt21Off

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    CALL AsmOuterrupt21

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    POP  CS:retInt21Off      ; interrupters IP
    POP  CS:retInt21Seg      ; interrupters CS
    POP  CS:unusedFlags      ; throw away INT flags

    JMP  DWORD PTR CS:retInt21Off


Int21ExitCall:
    POPF

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    CALL AsmInterrupt21

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    PUSHF                          ; Match the upcoming POP
    MOV  CS:inside, FALSE

Int21ExitJump:
    POPF
    JMP  DWORD PTR CS:oldInt21Off
Int21 ENDP
$EJECT

AsmInterrupt21 PROC NEAR
    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX

    CALL PLMInterrupt21

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF
    RET
AsmInterrupt21 ENDP
$EJECT

AsmOuterrupt21 PROC NEAR
    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX

    CALL PLMOuterrupt21

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF
    RET
AsmOuterrupt21 ENDP
$EJECT

Int20 PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int20Exit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt20

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int20Exit:
    POPF
    JMP DWORD PTR CS:oldInt20Off
Int20 ENDP
$EJECT

Int22 PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int22Exit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt22

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int22Exit:
    POPF
    JMP DWORD PTR CS:oldInt22Off
Int22 ENDP
$EJECT

Int23 PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int23Exit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt23

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int23Exit:
    POPF
    JMP DWORD PTR CS:oldInt23Off
Int23 ENDP
$EJECT

Int24 PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int24Exit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt24

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int24Exit:
    POPF
    JMP DWORD PTR CS:oldInt24Off
Int24 ENDP
$EJECT

Int25 PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int25Exit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt25

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int25Exit:
    POPF
    JMP DWORD PTR CS:oldInt25Off
Int25 ENDP
$EJECT

Int26 PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int26Exit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt26

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int26Exit:
    POPF
    JMP DWORD PTR CS:oldInt26Off
Int26 ENDP
$EJECT

Int27 PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int27Exit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt27

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int27Exit:
    POPF
    JMP DWORD PTR CS:oldInt27Off
Int27 ENDP
$EJECT

Int28 PROC FAR
;    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int28Exit

;    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt28

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

;    PUSHF

Int28Exit:
;    POPF
    JMP DWORD PTR CS:oldInt28Off
Int28 ENDP
$EJECT

Int29 PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int29Exit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt29

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int29Exit:
    POPF
    JMP DWORD PTR CS:oldInt29Off
Int29 ENDP
$EJECT

Int2A PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int2AExit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt2A

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int2AExit:
    POPF
    JMP DWORD PTR CS:oldInt2AOff
Int2A ENDP
$EJECT

Int2B PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int2BExit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt2B

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int2BExit:
    POPF
    JMP DWORD PTR CS:oldInt2BOff
Int2B ENDP
$EJECT

Int2C PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int2CExit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt2C

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int2CExit:
    POPF
    JMP DWORD PTR CS:oldInt2COff
Int2C ENDP
$EJECT

Int2D PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int2DExit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt2D

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int2DExit:
    POPF
    JMP DWORD PTR CS:oldInt2DOff
Int2D ENDP
$EJECT

Int2E PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int2EExit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt2E

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int2EExit:
    POPF
    JMP DWORD PTR CS:oldInt2EOff
Int2E ENDP
$EJECT

Int2F PROC FAR
    PUSHF

    CMP  BYTE PTR CS:inside, TRUE
    JE   Int2FExit

    POPF

    MOV  CS:inside, TRUE

    MOV  CS:userStackSS, SS
    MOV  CS:userStackSP, SP

    CLI
    MOV  SS, CS:intrStackSS
    MOV  SP, CS:intrStackSP
    STI

    PUSHF
    PUSH AX
    PUSH BX
    PUSH CX
    PUSH DX
    PUSH SI
    PUSH DI
    PUSH BP
    PUSH DS
    PUSH ES

    MOV  AX, SEG DGROUP:lastDataWord
    MOV  DS, AX

    MOV  AX, SP
    PUSH SS
    PUSH AX
    CALL PLMInterrupt2F

    POP  ES
    POP  DS
    POP  BP
    POP  DI
    POP  SI
    POP  DX
    POP  CX
    POP  BX
    POP  AX
    POPF

    CLI
    MOV  SS, CS:userStackSS
    MOV  SP, CS:userStackSP
    STI

    MOV  CS:inside, FALSE

    PUSHF

Int2FExit:
    POPF
    JMP DWORD PTR CS:oldInt2FOff
Int2F ENDP
$EJECT

retInt21Off DW ?
retInt21Seg DW ?

oldInt21Off DW ?
oldInt21Seg DW ?

;---------------

oldInt20Off DW ?
oldInt20Seg DW ?

oldInt22Off DW ?
oldInt22Seg DW ?

oldInt23Off DW ?
oldInt23Seg DW ?

oldInt24Off DW ?
oldInt24Seg DW ?

oldInt25Off DW ?
oldInt25Seg DW ?

oldInt26Off DW ?
oldInt26Seg DW ?

oldInt27Off DW ?
oldInt27Seg DW ?

oldInt28Off DW ?
oldInt28Seg DW ?

oldInt29Off DW ?
oldInt29Seg DW ?

oldInt2AOff DW ?
oldInt2ASeg DW ?

oldInt2BOff DW ?
oldInt2BSeg DW ?

oldInt2COff DW ?
oldInt2CSeg DW ?

oldInt2DOff DW ?
oldInt2DSeg DW ?

oldInt2EOff DW ?
oldInt2ESeg DW ?

oldInt2FOff DW ?
oldInt2FSeg DW ?
$EJECT

inside       DB FALSE

intrStackSS  DW ?
intrStackSP  DW ?

userStackSS  DW ?
userStackSP  DW ?

oldCpmJmpOff DW ?
oldCpmJmpSeg DW ?

callersCS    DW ?
unusedFlags  DW ?

CODE    ENDS


DATA    SEGMENT  PUBLIC 'DATA'

             DW 500 DUP (?)
stackTop     DW ?

DATA    ENDS


CONST   SEGMENT  PUBLIC 'CONST'

lastConstant DW ?

CONST   ENDS


LCODE   SEGMENT  PUBLIC 'CODE'

lastCodeWord DW ?

LCODE   ENDS


LDATA   SEGMENT  PUBLIC 'DATA'

lastDataWord DW ?

LDATA   ENDS


        END
